/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.remote.Mirror;
import net.montoyo.mcef.remote.MirrorManager;
import net.montoyo.mcef.utilities.DummyProgressListener;
import net.montoyo.mcef.utilities.IProgressListener;
import net.montoyo.mcef.utilities.Log;
import net.montoyo.mcef.utilities.SizedInputStream;
import org.cef.OS;

public class Util2 {
    private static final DummyProgressListener DPH = new DummyProgressListener();
    private static final String HEX = "0123456789abcdef";

    public static double clamp(double d, double min, double max) {
        if (d < min) {
            return min;
        }
        if (d > max) {
            return max;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extract(File zip, File out) {
        ZipInputStream zis;
        if (OS.isMacintosh()) {
            try {
                Process unzip = Runtime.getRuntime().exec(new String[]{"/usr/bin/unzip", zip.getAbsolutePath(), "-d", out.getAbsolutePath()});
                unzip.waitFor();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            zis = new ZipInputStream(new FileInputStream(zip));
        }
        catch (FileNotFoundException e) {
            Log.error("Couldn't extract %s: File not found.", zip.getName());
            e.printStackTrace();
            return false;
        }
        try {
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                int read;
                if (ze.isDirectory()) continue;
                File dst = new File(out, ze.getName());
                Util2.delete(dst);
                Util2.mkdirs(dst);
                FileOutputStream fos = new FileOutputStream(dst);
                byte[] data = new byte[65536];
                while ((read = zis.read(data)) > 0) {
                    fos.write(data, 0, read);
                }
                Util2.close(fos);
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            Log.error("Couldn't extract a file from %s. Maybe you're missing some permissions?", zip.getName());
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            Log.error("IOException while extracting %s.", zip.getName());
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            Util2.close(zis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash(File fle) {
        FileInputStream fis;
        try {
            fis = new FileInputStream(fle);
        }
        catch (FileNotFoundException e) {
            Log.error("Couldn't hash %s: File not found.", fle.getName());
            e.printStackTrace();
            return null;
        }
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            sha.reset();
            int read = 0;
            byte[] buffer = new byte[65536];
            while ((read = fis.read(buffer)) > 0) {
                sha.update(buffer, 0, read);
            }
            byte[] digest = sha.digest();
            Object hash = "";
            for (int i = 0; i < digest.length; ++i) {
                int b = digest[i] & 0xFF;
                int left = b >>> 4;
                int right = b & 0xF;
                hash = (String)hash + HEX.charAt(left);
                hash = (String)hash + HEX.charAt(right);
            }
            String string = hash;
            return string;
        }
        catch (IOException e) {
            Log.error("IOException while hashing file %s", fle.getName());
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            Log.error("Holy crap this shouldn't happen. SHA-1 not found!!!!", new Object[0]);
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            Util2.close(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean download(String res, File dst, boolean gzip, IProgressListener ph) {
        FileOutputStream fos;
        InputStream is;
        SizedInputStream sis;
        String err = "Couldn't download " + dst.getName() + "!";
        ph = Util2.secure(ph);
        ph.onTaskChanged("2:Downloading " + dst.getName());
        if (MCEF.writeMirrorData) {
            try {
                sis = Util2.openStream(res, err);
                String path = res;
                File dst1 = new File("data/" + path);
                if (!dst1.exists()) {
                    dst1.getParentFile().mkdirs();
                }
                FileOutputStream outputStream = new FileOutputStream(dst1);
                outputStream.write(sis.readAllBytes());
                sis.close();
                outputStream.flush();
                outputStream.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if ((sis = Util2.openStream(res, err)) == null) {
            return false;
        }
        if (gzip) {
            try {
                is = new GZIPInputStream(sis);
            }
            catch (IOException e) {
                Log.error("Couldn't create GZIPInputStream: IOException.", new Object[0]);
                e.printStackTrace();
                Util2.close(sis);
                return false;
            }
        } else {
            is = sis;
        }
        Util2.delete(dst);
        Util2.mkdirs(dst);
        try {
            fos = new FileOutputStream(dst);
        }
        catch (FileNotFoundException e) {
            Log.error("%s Couldn't open the destination file. Maybe you're missing rights.", err);
            e.printStackTrace();
            Util2.close(is);
            return false;
        }
        byte[] data = new byte[65536];
        double total = sis.getContentLength();
        double cur = 0.0;
        try {
            int read;
            while ((read = is.read(data)) > 0) {
                fos.write(data, 0, read);
                ph.onProgressed((cur += (double)sis.resetLengthCounter()) / total * 100.0);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Log.error("%s IOException while downloading.", err);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            Util2.close(is);
            Util2.close(fos);
        }
    }

    public static boolean download(String res, File dst, IProgressListener ph) {
        return Util2.download(res, dst, false, ph);
    }

    public static IProgressListener secure(IProgressListener pl) {
        return pl == null ? DPH : pl;
    }

    public static File rename(File src, String name) {
        File ret = new File(src.getParentFile(), name);
        if (src.renameTo(ret)) {
            return ret;
        }
        return null;
    }

    public static void mkdirs(File f) {
        File p = f.getParentFile();
        if (!p.exists()) {
            p.mkdirs();
        }
    }

    public static void delete(String f) {
        Util2.delete(new File(f));
    }

    public static void delete(File f) {
        if (!f.exists() || f.delete()) {
            return;
        }
        File mv = new File(f.getParentFile(), "deleteme" + (int)(Math.random() * 100000.0));
        if (f.renameTo(mv)) {
            if (!mv.delete()) {
                mv.deleteOnExit();
            }
            return;
        }
        Log.warning("Couldn't delete file! If there's any problems, please try to remove it yourself. Path: %s", f.getAbsolutePath());
    }

    public static SizedInputStream openStream(String res, String err) {
        while (true) {
            URLConnection conn;
            try {
                Mirror m = MirrorManager.INSTANCE.getCurrent();
                conn = m.getResource(res);
            }
            catch (MalformedURLException e) {
                Log.error("%s Is the mirror list broken?", err);
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                Log.error("%s Is your antivirus or firewall blocking the connection?", err);
                e.printStackTrace();
                return null;
            }
            try {
                long len = -1L;
                boolean failed = true;
                if (conn instanceof HttpURLConnection) {
                    block15: {
                        try {
                            Method m = HttpURLConnection.class.getMethod("getContentLengthLong", new Class[0]);
                            len = (Long)m.invoke((Object)conn, new Object[0]);
                            failed = false;
                        }
                        catch (NoSuchMethodException m) {
                        }
                        catch (IllegalAccessException m) {
                        }
                        catch (InvocationTargetException te) {
                            if (!(te.getTargetException() instanceof IOException)) break block15;
                            throw (IOException)te.getTargetException();
                        }
                    }
                    if (failed) {
                        len = conn.getContentLength();
                    }
                    return new SizedInputStream(conn.getInputStream(), len);
                }
                Mirror m = MirrorManager.INSTANCE.getCurrent();
                String dir = (m.getURL() + "/" + res).substring("file://".length());
                len = new File(dir).length();
                return new SizedInputStream(new FileInputStream(dir), len);
            }
            catch (IOException e) {
                int rc = -1;
                try {
                    if (conn instanceof HttpURLConnection) {
                        rc = ((HttpURLConnection)conn).getResponseCode();
                    }
                }
                catch (IOException ie) {
                    Log.error("%s Couldn't even get the HTTP response code!", err);
                    ie.printStackTrace();
                    return null;
                }
                Log.error("%s HTTP response is %d; trying with another mirror.", err, rc);
                if (MirrorManager.INSTANCE.markCurrentMirrorAsBroken()) continue;
                Log.error("%s All mirrors seems broken.", err);
                return null;
            }
            break;
        }
    }

    public static void close(Object o) {
        try {
            o.getClass().getMethod("close", new Class[0]).invoke(o, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isSameFile(Path p1, Path p2) {
        try {
            return Files.isSameFile(p1, p2);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getenv(String name) {
        String ret = System.getenv(name);
        return ret == null ? "" : ret;
    }
}

